#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

struct tacka
{
    int x, y;
};
int presek(tacka O, tacka A, tacka B)
{
    return (A.x - O.x) * (B.y - O.y) - (A.y - O.y) * (B.x - O.x);
}
vector<tacka> KonveksniDeo(vector<tacka>& tacke) {
    int n = tacke.size();
    if (n < 3) return tacke;

    vector<tacka> deo;
    sort(tacke.begin(), tacke.end(), [](tacka a, tacka b)
        {
        return (a.x == b.x) ? (a.y < b.y) : (a.x < b.x);
        });
    for (int i = 0; i < n; i++) {
        while (deo.size() >= 2 && presek(deo[deo.size() - 2], deo.back(), tacke[i]) <= 0) {
            deo.pop_back();
        }
        deo.push_back(tacke[i]);
    }
    int VelicinaDela = deo.size();
    for (int i = n - 2; i >= 0; i--) {
        while (deo.size() > VelicinaDela && presek(deo[deo.size() - 2], deo.back(), tacke[i]) <= 0) {
            deo.pop_back();
        }
        deo.push_back(tacke[i]);
    }

    deo.pop_back();
    return deo;
}
double AlgoritamPertle(const vector<tacka>& deo) {
    double povrsina = 0;
    int n = deo.size();
    for (int i = 0; i < n; i++) {
        povrsina += (deo[i].x * deo[(i + 1) % n].y) - (deo[i].y * deo[(i + 1) % n].x);
    }
    return abs(povrsina) / 2.0;
}

int main() {
    int n;
    cin >> n;

    vector<tacka> tacke;
    for (int i = 0; i < n; i++) {
        tacka p;
        cin >> p.x >> p.y;
        if (p.x % 2 == 0 && p.y % 2 == 0)
        {
            tacke.push_back(p);
        }
    }
    vector<tacka> deo = KonveksniDeo(tacke);
    double povrsina = AlgoritamPertle(deo);
    cout << povrsina << endl;
    return 0;
}